<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Application Variables
        // AppInfo
        Setting(['app_name' => env('APP_NAME', 'Administrative System')])->save();
        Setting(['app_url' => env('APP_URL', 'http://bdtravel.test')])->save();
        Setting(['app_description' => 'BD Travel Dashboard'])->save();
        Setting(['app_keyword' => ''])->save();
        Setting(['app_title' => ''])->save();
        Setting(['app_slogan' => ''])->save();
        // AppContact
        Setting(['phone' => '+8801711-000000'])->save();
        Setting(['email' => 'support@bdtravel.test'])->save();
        setting(['country' => 'Bangladesh'])->save();
        setting(['state' => 'Dhaka'])->save();
        setting(['city' => 'Rampura'])->save();
        Setting(['street' => '128 Ullan'])->save();
        Setting(['postal_code' => '1200'])->save();
        Setting(['facebook' => env('FACEBOOK_URL', 'bdtravel')])->save();
        Setting(['twitter' => env('TWITTER_URL', 'bdtravel')])->save();
        Setting(['youtube' => env('YOUTUBE_URL', 'bdtravel')])->save();
        Setting(['instagram' => env('INSTAGRAM_URL', 'bdtravel')])->save();
        Setting(['linkedin' => env('LINKEDIN_URL', 'bdtravel')])->save();
        Setting(['telegram' => env('TELEGRAM_URL', 'bdtravel')])->save();
        Setting(['whatsapp' => env('WHATSAPP', 'bdtravel')])->save();
        // ! Website Propertice
        Setting(['short_light_logo' => ('panel/images/short-logo.jpg')])->save();
        Setting(['short_dark_logo' => ('panel/images/short-logo.jpg')])->save();
        Setting(['dark_logo' => ('panel/images/dark-logo.png')])->save();
        Setting(['light_logo' => ('panel/images/light-logo.png')])->save();
        Setting(['favicon' => ('favicon/favicon.png')])->save();
        Setting(['ogimage' => ('panel/images/banner.png')])->save();
        Setting(['avatar' => ('panel/images/user/avatar.png')])->save();
        Setting(['theme' => 'light'])->save();
        Setting(['navbar' => '#343a40'])->save();
        Setting(['sidebar' => 'dark'])->save();
        Setting(['currency' => 'BDT'])->save();
        // ! App Config
        Setting(['google_analytics_id' => 'UA-123456789-1'])->save();
        Setting(['google_tag_id' => 'UA-123456789-1'])->save();
        Setting(['publisher_id' => 'ca-pub-12345678912345678'])->save();
        Setting(['disqus_short_name' => 'myserver_'])->save();
        Setting(['analytics_view_id' => '123456789'])->save();
        Setting(['credential_file' => 'credential.json'])->save();
        Setting(['google_map_code' => 'https://www.google.com/maps/embed/v1/place?q=place_id:ChIJZW3qh40Q_zkRz2Ey-U4DfWI&key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8'])->save();

        // Payment Variables
        Setting(['stripe_sandbox' => 1])->save();
        Setting(['stripe_key' => 'pk_test_51I8PUtFEwlPBHeq50vILaOjtCA7FJFk1vVIOOkFCEjtbNboGQCI2AwrQNZuQ1ClLUnl5fk3Jkn9uFVmcpgQ48geU00T3xPc6WH1'])->save();
        Setting(['stripe_secret' => 'sk_test_51I8PUtFEwlPBHeq5Gpb4WSANuA9TP2lLwB92zYdicQ30sqYPJRqulNymnWoA4rLq5bUITvGUZC8uMCpDhWLKdJm000o7r1VkNq1'])->save();
        Setting(['stripe_status' => 1])->save();

        setting(['bkash_sandbox' => 1])->save();
        setting(['bkash_app_key' => ''])->save();
        setting(['bkash_app_secret' => ''])->save();
        setting(['bkash_app_username' => ''])->save();
        setting(['bkash_app_password' => ''])->save();
        setting(['bkash_status' => 0])->save();

        // Authentication Variables
        Setting(['captcha' => 0])->save();
        Setting(['captcha_key' => ''])->save();
        Setting(['captcha_secret' => ''])->save();
        Setting(['2fa' => 0])->save();
        Setting(['email_verification' => 1])->save();
        Setting(['registration' => 1])->save();

        // Social Login
        Setting(['google_client_id' => ''])->save();
        Setting(['google_client_secret' => ''])->save();

        Setting(['facebook_client_id' => ''])->save();
        Setting(['facebook_client_secret' => ''])->save();

        Setting(['twitter_client_id' => ''])->save();
        Setting(['twitter_client_secret' => ''])->save();
    }
}
